<?php
if ($vbulletin->options['dbtech_vbsecurity_active'])
{
	if ($vbulletin->GPC['usergroupid'])
	{
		// Shorthand
		$existing = $vbulletin->usergroupcache[$vbulletin->GPC['usergroupid']];

		foreach ((array)$vbulletin->GPC['usergroup'] as $field => $value)
		{
			if (!in_array($field, VBSECURITY::$watchers['usergroup']))
			{
				// We're not even dealing with this
				continue;
			}

			$vbsecInfo = array(
				'script' 	=> 'usergroup',
				'action' 	=> 'edited',
				'id' 		=> $vbulletin->GPC['usergroupid'],
				'title' 	=> $existing['title'],
				'field' 	=> $field,
				'old' 		=> strval($existing[$field]),
				'new' 		=> strval($value),
			);

			if ($vbsecInfo['old'] !== $vbsecInfo['new'])
			{
				// Update this array
				$vbsecInfo['differences'] = 'usergroup id: ' . $vbsecInfo['id'] . ' (' . $vbsecInfo['title'] . ') - ' . $vbsecInfo['old'] . ' &raquo; ' . $vbsecInfo['new'];

				// Update the watcher
				VBSECURITY::updateWatcher($vbsecInfo);
			}
		}
	}
	else
	{
		$vbsecInfo = array(
			'script' 	=> 'permissions',
			'action' 	=> 'added',
			'id' 		=> $vbulletin->GPC['usergroupid'],
			'title' 	=> $vbulletin->GPC['usergroup']['title'],
			'field' 	=> 'newusergroup',
			'old' 		=> 0,
			'new' 		=> $vbulletin->GPC['usergroupid'],
		);

		// Update this array
		$vbsecInfo['differences'] = $vbsecInfo['title'];

		// Update the watcher
		VBSECURITY::updateWatcher($vbsecInfo);
	}
}
?>